(define/contract (combine n k)
  (-> exact-integer? exact-integer? (listof (listof exact-integer?)))
  (let loop ([start 1] [path '()] [result '()])
    (if (= (length path) k)
        (cons (reverse path) result)
        (let ([end (+ (- n k) (length path) 1)])
          (for/fold ([res result])
                    ([i (in-range start (+ end 1))])
            (loop (+ i 1) (cons i path) res)))))))